#!/usr/bin/python3

import matplotlib.pyplot as plt
import numpy as np
import matplotlib.gridspec as gridspec
from scipy.stats import linregress

# Fit data.
def fit(a, b):
    res = linregress(a, b)
    return a*res.slope+res.intercept, res

# Get data.
fn   = "energies.txt"
data = np.loadtxt(fn, skiprows = 1).transpose()
d    = data[0]
e1   = data[1]
e2   = data[2]
idx1 = 4
idx2 = 2
d1_fit = d[idx1:]
d2_fit = d[idx2:]
e1_fit, res1 = fit(1/d1_fit, e1[idx1:])
e2_fit, res2 = fit(1/d2_fit, e2[idx2:])

# Draw figures.
plt.subplot(1, 2, 1) 
plt.plot(d, e1, "ro", label="Excitation: 48->49")
plt.plot(d1_fit, e1_fit, "r-", label="Fit")
plt.text(4, 3.35, f"$\omega = {res1.intercept:.3f}{res1.slope:.3f}/d$", fontsize=12, color='red')
plt.text(4, 3.33, f"$R^2$ = {res1.rvalue**2:.3f}", fontsize=12, color='red')
plt.xlabel("$d$ (Angstrom)", fontsize=12)
plt.ylabel("$\omega$ (eV)", fontsize=12)
plt.legend()
plt.subplot(1, 2, 2) 
plt.plot(d, e2, "bo", label="Excitation: 48->50")
plt.plot(d2_fit, e2_fit, "b-", label="Fit")
plt.text(6, 7.025, f"$\omega = {res2.intercept:.3f}{res2.slope:.3f}/d$", fontsize=12, color='blue')
plt.text(6, 7.015, f"$R^2$ = {res2.rvalue**2:.3f}", fontsize=12, color='blue')
plt.xlabel("$d$ (Angstrom)", fontsize=12)
plt.ylabel("$\omega$ (eV)", fontsize=12)
plt.legend()
# Finally, plot.
plt.show()

