import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm

def plot_contour_from_file(filename):
    # Read file.
    data = np.loadtxt(filename)
    x = data[:, 0]
    y = data[:, 1]
    x *= 10         # To Angstrom
    y *= 0.23900574 # To kcal/mol
    # Plot.
    plt.figure(figsize=(10, 8))
    plt.plot(x,y)
    # Style.    
    plt.xlabel('$d\equiv d_1-d_2$ (Angstrom)', fontsize=12)
    plt.ylabel('$F(d)$ (kcal/mol)', fontsize=12)
    plt.title('Free Energy Surface $F(d)$', fontsize=14)
    plt.tight_layout()    
    # Show.
    plt.show()

if __name__ == "__main__":
    plot_contour_from_file('fes.dat')