import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm

def plot_contour_from_file(filename):
    # Read file.
    data = np.loadtxt(filename)
    x = data[:, 0]
    y = data[:, 1]
    z = data[:, 2]
    x_unique = np.unique(x)
    y_unique = np.unique(y)
    # Create grids.
    X, Y = np.meshgrid(x_unique, y_unique)
    Z = np.zeros_like(X)
    for i, xi in enumerate(x_unique):
        for j, yi in enumerate(y_unique):
            mask = (x == xi) & (y == yi)
            if np.any(mask):
                Z[j, i] = z[mask][0]
    X *= 180/3.1415926 # To degree
    Y *= 180/3.1415926 # To degree
    Z *= 0.23900574    # To kcal/mol
    # Plot.
    plt.figure(figsize=(10, 8))
    contourf = plt.contourf(X, Y, Z, levels=25, cmap='jet')
    contour = plt.contour(X, Y, Z, levels=25, colors='black', linewidths=1)
    # Style.
    cbar = plt.colorbar(contourf)
    cbar.set_label('$F(\phi, \psi)$ (kcal/mol)', fontsize=12)    
    plt.xlabel('$\phi$ (degree)', fontsize=12)
    plt.ylabel('$\psi$ (degree)', fontsize=12)
    plt.title('Free Energy Surface $F(\phi, \psi)$', fontsize=14)
    plt.tight_layout()    
    # Show.
    plt.show()

if __name__ == "__main__":
    plot_contour_from_file('fes.dat')